///////////////////////////////////////////////////////////
//
// "Aluminum"
// Ryan Thaut & Hmmwhatsthisdo
// 05.17.2008
//
// Last Modified: 6/13/09
// Version: 1.0 (Carbon 1.1)
//
// Sections:
//		Colors			- all the colors used by the scheme
//		BaseSettings	- contains settings for app to use to draw controls
//		Fonts			- list of all the fonts used by app
//		Appearances		- description of all the borders
// Aluminum Updates DONE
//
///////////////////////////////////////////////////////////
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		// Basic Colors
		"White"									"000 000 000 255"
		"TransparentBlack"						"255 255 255 128"
		"Black"									"255 255 255 255"
		"Blank"									"254 254 254 000"
		"Red"									"255 103 103 255"
		"RedDark"								"255 155 155 255"
		"RedBright"								"255 123 123 255"
		
		// Base Shades
		"BaseBright"							"185 185 185 255"
		"BaseLight"								"199 199 199 255"
		"BaseNormal"							"241 241 241 255"
		"BaseDark"								"227 227 227 255"
		"BasePanelTop"							"200 200 200 255"
		
		// Misc. Colors
		"SelectedBGColor"						"213 213 213 255"
		"SliderTickColor"						"115 115 115 255"
		"TitleTop"								"199 199 199 255"
		"TitleBottom"							"227 227 227 255"
		
		"FriendPanelHoverOutline"				"213 213 213 255"
		"FriendPanelSelectedOutline"			"199 199 199 255"
		
		// Text Colors
		"TextShadow"							"227 227 227 255"
		"TextDisabled"							"185 185 185 255"
		"TextDark"								"143 143 143 255"
		"TextDim"								"115 115 115 255"
		"TextNormal"							"087 087 087 255"
		"TextBright"							"031 031 031 255"
		"TextURL"								"087 087 087 255"
		"ProgressColor"							"215 155 155 255"
		"SectionHeaderText"						"031 031 031 255"
		"SectionHeaderText2"					"031 031 031 255"
		"SectionHeaderBG"						"255 155 155 255"
		"NotificationBodyText"					"155 213 255 255"
		
		"FancyButtonTextNormal"					"087 087 087 000"
		"FancyButtonTextHover"					"087 087 087 000"
		
		// Button Border Colors
		"ButtonBorderNormal"					"199 199 199 255"
		"ButtonBorderHover"						"179 184 187 255"
		"ButtonBorderDown"						"199 199 199 255"
		"ButtonBorderDisabled"					"213 213 213 255"
		"ButtonBorderDefault"					"185 185 185 255"
		"ButtonBorderDefaultHover"				"185 185 185 255"
		
		// Input Border Colors
		"InputGradientLight"					"199 199 199 255"
		"InputGradientDark"						"227 227 227 255"
		"InputBorderBackground"					"241 241 241 255"
		
		// Generic Border Colors
		"GenericBorderBright"					"185 185 185 255"
		"GenericBorderDisabled"					"056 056 056 255"
		"GenericBorderDark"						"241 241 241 255"
		
		// Seperator Colors
		"SepDark"								"241 241 241 255"
		"SepLight"								"185 185 185 255"
		
		// Tab Background Colors
		"TabActive"								"195 200 203 255"
	}

	///////////////////// BASE SETTINGS ////////////////////////
	BaseSettings
	{
		// VGUI Controls Color Specifications
		CheckButton.BgColor						BaseNormal
		CheckButton.Border1  					GenericBorderDark
		CheckButton.Border2  					GenericBorderBright
		CheckButton.Check						RedBright
		DragDrop.DragFrame						"000 000 000 192"
		DragDrop.DropFrame						"000 000 000 255"
		Frame.ClientInsetX						10
		Frame.ClientInsetY						35
		Frame.BgColor							BaseLight
		Frame.OutOfFocusBgColor					BaseLight
		Frame.FocusTransitionEffectTime			"0"
		Frame.TransitionEffectTime				"0.25"
		Frame.OnDragAlphaDelayTime				"0.15"
		Frame.OnDragAlphaMultiplier				"1.0"
		Frame.AutoSnapRange						"6"
		Frame.UsesAlphaBlending					1
		FrameSystemButton.Icon					"Resource/icon_steam"
		FrameSystemButton.DisabledIcon			"Resource/icon_steam_disabled"
		Notifications.PanelPosition				"BottomRight"
		Notifications.SlideDirection			"Vertical"
		Notifications.FadeInTime				"0.55"
		Notifications.FadeOutTime				"0.55"
		Notifications.DisplayTime				"6.0"
		Notifications.StackSize					"3"
		ListPanel.TextColor						TextBright
		ListPanel.BgColor						Blank
		ListPanel.SelectedTextColor				TextBright
		ListPanel.SelectedBgColor				SelectedBGColor
		ListPanel.SelectedOutOfFocusBgColor		SelectedBGColor
		ListPanel.DisabledTextColor				TextDisabled
		ListPanel.DisabledSelectedTextColor		TextDisabled
		ListPanel.EmptyListInfoTextColor		TextDim
		ListPanel.RowHeight						20
		ListPanel.PerPixelScrolling				1
		Menu.TextInset							6
		Panel.FgColor							BaseLight
		Panel.BgColor							Blank
		PropertySheet.TransitionEffectTime		0
		PropertySheet.TabGap					15
		RichText.TextColor						TextBright
		RichText.BgColor						Blank
		RichText.SelectedTextColor				TextBright
		RichText.SelectedBgColor				SelectedBGColor
		RichText.InsetX							6
		RichText.InsetY							6
		RichText.URLColor						TextURL
		ScrollBar.Wide							21
		SectionedListPanel.CollapserWidth		16
		TextEntry.CursorColor					White
		TextEntry.IMEBGColor					White
		TextEntry.IMEFGColor					Black
		
		// Steam-Specific Settings
		GamesList.InstalledAppColor				TextBright
		GamesList.NotInstalledAppColor			TextDim
		GamesList.ReadyStatusColor				TextDim
		GamesList.UpdatingStatusColor			RedBright
		GamesList.NotInstalledStatusColor		TextDim
		
		// Friends List Colors
		Friends.InGameColor						"000 217 000 255"
		Friends.OnlineColor						"7 175 231 255"
		Friends.OfflineColor					"087 087 087 255"
		Friends.IgnoredColor					"255 155 155 255"
		Friends.NoAvatarOver					TextBright
		
		// P2P Graph Colors
		P2P.DownloadColor						"062 062 062 255"
		P2P.UploadColor							"67 103 108 255"
		P2PBlockStatus.Outline					"155 155 155 255"
		P2PBlockStatus.CompletionBar			"085 168 255 255"
		P2PBlockStatus.CompletionBarBg			"182 182 182 255"
		P2PBlockStatus.BlockStatusUnknown		"255 103 103 192"
		P2PBlockStatus.BlockStatusLow			"178 183 178 255"
		P2PBlockStatus.BlockStatusHigh			"101 195 255 255"
		P2PBlockStatusDetails.c_dling			"255 103 103 255"
		P2PBlockStatusDetails.c_both			"049 176 255 255"
		P2PBlockStatusDetails.c_peer			"000 034 034 255"
		P2PBlockStatusDetails.c_local			"063 143 063 255"
		P2PBlockStatusDetails.c_missing			"000 000 000 255"
		P2PBlockStatusDetails.c_error			"128 128 128 255"
		P2PBlockStatusDetails.c_unused			"255 255 255 255"
		
		// Chat Window Colors
		ChatOthersTextColor						TextBright
		ChatOwnTextColor						TextDim
		ChatGradientTop							BaseLight
		ChatGradientBottom						BaseNormal
		Slider.NobColor							SliderTickColor
	}
	
	//////////////////// CONTROLS //////////////////////////////
	Controls
	{
		BaseControls
		{
			Button
			{
				appearance						ButtonBorderNormal
				bgcolor							Blank
				textcolor						TextNormal
				mouseover
				{
					appearance					ButtonBorderHover
					textcolor 					TextNormal
				}
				mousedown	
				{
					appearance 					ButtonBorderDepressed
					textcolor					TextDim
				}
				disabled
				{
					appearance					ButtonBorderDisabled
					textcolor					TextDisabled
					shadowtextcolor				TextShadow
				}
				keyfocus
				{ 
					appearance					ButtonBorderNormal
					textcolor 					TextNormal
				}
				keyfocus_mouseover		
				{ 
					appearance 					ButtonBorderHover
					textcolor 					TextNormal
				}
				defaultbutton
				{ 
					appearance					ButtonBorderDefault
					textcolor					TextBright
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonBorderDefaultHover
					textcolor					TextBright
				}
			}
			
			GripPanel
			{
				textcolor						BaseLight
				bgcolor							BaseLight
			}
			
			CheckButton
			{
				textcolor						TextNormal
				mouseover
				{
					textcolor 					TextNormal
				}
				mousedown	
				{
					textcolor 					TextDim
				}
				selected	
				{
					textcolor 					TextBright
				}
				keyfocus
				{
					textcolor 					TextNormal
				}
				keyfocus_mouseover
				{
					textcolor 					TextNormal
				}
				selected_mouseover	
				{ 
					textcolor 					TextBright
				}
				selected_mousedown
				{
					textcolor 					TextDim
				}
				selected_keyfocus
				{
					textcolor 					TextBright
				}
				selected_keyfocus_mouseover
				{
					textcolor 					TextBright 
				}
				disabled
				{
					textcolor					TextDisabled
				}
				selected_disabled
				{
					textcolor					TextDisabled
				}
			}
			
			CheckButtonList
			{
				appearance						ListPanelBorder
			}
			
			ComboBox
			{
				appearance						InputBorder
				bgcolor							Blank
				textcolor						TextNormal
				selectedtextcolor				TextBright
				selectedbgcolor					Blank
				mouseover
				{
					textcolor 					TextBright
				}
				mousedown
				{
					textcolor 					TextBright
				}
				keyfocus
				{
					textcolor 					TextBright
				}
				disabled
				{
					appearance					InputBorderDisabled
					bgcolor						Blank
					textcolor					TextDim
					selectedtextcolor			TextNormal
					selectedbgcolor				Blank
				}
			}
			
			ComboBoxButton
			{
				textcolor						TextNormal
				mouseover
				{
					textcolor 					TextBright
				}
				disabled
				{
					textcolor 					TextDim
				}
			}
			
			ContextLabel
			{
				textcolor						TextDim
			}
			
			Divider
			{
				appearance						InsetBorder
			}
			
			Frame
			{
				appearance						FrameBorder
			}
			
			FrameButton
			{
				appearance						FrameButtonNormal
				bgcolor							Blank
				textcolor						TextDim
				mouseover
				{
					appearance					FrameButtonHover
					textcolor					TextNormal
				}
				outoffocus	
				{
					appearance					FrameButtonNormal
					textColor 					TextDark
				}
			}
		
			FrameSystemButton
			{
				appearance						NoBorder
				textcolor						TextNormal
			}
			
			FrameTitle
			{
				appearance						NoBorder
				bgcolor							Blank
				textcolor						TextDim
				outoffocus
				{
					textcolor					TextDark
				}
			}
			
			FrameBRGripPanel
			{
				appearance						ResizeBorder
				textcolor						Blank
				mouseover
				{
					appearance					ResizeBorder
				}
				mousedown	
				{
					appearance 					ResizeBorder
				}
				disabled
				{
					appearance					ResizeBorder
				}
			}
			
			CChatTitlePanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}
			
			CChatFriendTitlePanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}
			
			CChatHistoryPanel
			{
				appearance						ListPanelBorder
				textcolor						TextBright
				scrollbar_visible
				{
					appearance					ListPanelBorder
				}
			}
			
			CChatTextEntry
			{
				appearance						ChatInputBorder
				bgcolor							Blank
				textcolor						TextNormal
				selectedtextcolor				TextBright
				selectedbgcolor					TextDisabled
				disabled
				{
					appearance					ChatInputBorderDisabled
					bgcolor						Blank
					textcolor					TextDim
					selectedtextcolor			TextNormal
					selectedbgcolor				SelectedBGColor
				}
			}
			
			CChatUserPanel
			{
				appearance						ChatUserPanelDefault
				scrollbar_visible
				{
					appearance					ChatUserPanelDefault
				}
			}
			
			CFriendsListUserPanel
			{
				appearance						ListPanelInteriorBorder
			}
			
			CChatInviteBG
			{
				appearance						ChatInviteBG
			}
			
			CVoiceChatOffBG
			{
				appearance						VoiceChatOffBG
			}
			
			CVoiceChatOnBG
			{
				appearance						VoiceChatOnBG
			}
			
			CChatTitlePanelAffordance
			{
				appearance						FriendPanelAffordance
				bgcolor							Blank
				textcolor						TextNormal
				mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				mousedown
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				keyfocus
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				keyfocus_mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
			}
			
			CFriendPanel
			{
				appearance						FriendPanelDefault
				mouseover
				{
					appearance					FriendPanelMouseOver
				}
				selected
				{
					appearance					FriendPanelSelected
				}
				compact
				{
					appearance					Blank
					bgcolor						Blank
				}
				compact_selected
				{
					appearance					Blank
					bgcolor						SelectedBGColor
				}
			}
			
			CFriendPanelAffordance
			{
				appearance						FriendPanelAffordance
				bgcolor							Blank
				mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
				}
				mousedown
				{
					appearance					FriendPanelAffordanceMouseOver
				}
				keyfocus
				{
					appearance					FriendPanelAffordanceMouseOver
				}
				keyfocus_mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
				}
			}
			
			CFriendsListSectionHeader
			{
				appearance						NoBorder
				bgcolor							SectionHeaderBG
				textcolor						SectionHeaderText
			}
			
			CFriendsListSectionAffordance
			{
				appearance						FriendPanelAffordance
				bgcolor							Blank
				textcolor						TextNormal
				mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				mousedown
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				keyfocus
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
				keyfocus_mouseover
				{
					appearance					FriendPanelAffordanceMouseOver
					textcolor					TextBright
				}
			}
			
			CTaskbarButton
			{
				textcolor						TextNormal
				bgcolor							Blank
				appearance						NoBorder
				mouseover
				{
					textcolor 					TextBright
				}
				selected	
				{
					textcolor					TextBright
				}
				selected_mouseover	
				{
					textcolor					TextBright
				}
			}
			
			COverlayTaskbar
			{
				bgcolor							Black
			}
			
			COverlayMain
			{
				bgcolor							"255 255 255 128"
			}
			
			GraphPanel
			{
				textcolor						ProgressColor
				bgcolor							Blank
				appearance						ListPanelBorder
			}
			
			HTML
			{
				bgcolor							BaseDark
				appearance						HTMLExteriorBorder
			}
			
			HTMLInterior
			{
				bgcolor							Blank
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			icon_button_news
			{
				appearance						NewsButtonNormal
				textcolor						FancyButtonTextNormal
				mousedown
				{
					appearance 					NewsButtonHover
					textcolor					FancyButtonTextHover
				}
				keyfocus
				{
					appearance 					NewsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				mouseover
				{
					appearance 					NewsButtonHover
					textcolor 					FancyButtonTextHover
				}
				disabled
				{
					appearance 					NewsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				keyfocus_mouseover
				{
					appearance 					NewsButtonHover
					textcolor					FancyButtonTextHover
				} 
				defaultbutton
				{
					appearance 					NewsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				defaultbutton_mouseover
				{
					appearance 					NewsButtonHover
					textcolor 					FancyButtonTextHover
				}
			}
			
			icon_button_friends
			{
				appearance						FriendsButtonNormal
				textcolor						FancyButtonTextNormal
				mousedown
				{
					appearance 					FriendsButtonHover
					textcolor					FancyButtonTextHover
				}
				keyfocus
				{
					appearance 					FriendsButtonNormal
					textcolor 					FFancyButtonTextNormal
				}
				mouseover
				{
					appearance 					FriendsButtonHover
					textcolor 					FancyButtonTextHover
				}
				disabled
				{
					appearance 					FriendsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				keyfocus_mouseover
				{
					appearance 					FriendsButtonHover
					textcolor					FancyButtonTextHover
				} 
				defaultbutton
				{
					appearance 					FriendsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				defaultbutton_mouseover
				{
					appearance 					FriendsButtonHover
					textcolor 					FancyButtonTextHover
				}
			}
			
			icon_button_servers
			{
				appearance						ServersButtonNormal
				textcolor						FancyButtonTextNormal
				mousedown
				{
					appearance 					ServersButtonHover
					textcolor					FancyButtonTextHover
				}
				keyfocus
				{
					appearance 					ServersButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				mouseover
				{
					appearance 					ServersButtonHover
					textcolor 					FancyButtonTextHover
				}
				disabled
				{
					appearance 					ServersButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				keyfocus_mouseover
				{
					appearance 					ServersButtonHover
					textcolor					FancyButtonTextHover
				} 
				defaultbutton
				{
					appearance 					ServersButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				defaultbutton_mouseover
				{
					appearance 					ServersButtonHover
					textcolor 					FancyButtonTextHover
				}
			}
			
			icon_button_settings
			{
				appearance						SettingsButtonNormal
				textcolor						FancyButtonTextNormal
				mousedown
				{
					appearance 					SettingsButtonHover
					textcolor					FancyButtonTextHover
				}
				keyfocus
				{
					appearance 					SettingsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				mouseover
				{
					appearance 					SettingsButtonHover
					textcolor 					FancyButtonTextHover
				}
				disabled
				{
					appearance 					SettingsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				keyfocus_mouseover
				{
					appearance 					SettingsButtonHover
					textcolor					FancyButtonTextHover
				} 
				defaultbutton
				{
					appearance 					SettingsButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				defaultbutton_mouseover
				{
					appearance 					SettingsButtonHover
					textcolor 					FancyButtonTextHover
				}
			}
			
			icon_button_support
			{
				appearance						SupportButtonNormal
				textcolor						FancyButtonTextNormal
				mousedown
				{
					appearance 					SupportButtonHover
					textcolor					FancyButtonTextHover
				}
				keyfocus
				{
					appearance 					SupportButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				mouseover
				{
					appearance 					SupportButtonHover
					textcolor 					FancyButtonTextHover
				}
				disabled
				{
					appearance 					SupportButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				keyfocus_mouseover
				{
					appearance 					SupportButtonHover
					textcolor					FancyButtonTextHover
				} 
				defaultbutton
				{
					appearance 					SupportButtonNormal
					textcolor 					FancyButtonTextNormal
				}
				defaultbutton_mouseover
				{
					appearance 					SupportButtonHover
					textcolor 					FancyButtonTextHover
				}
			}
			
			icon_button_MiniMeShrink
			{
				appearance						ShrinkButtonNormal
				bgcolor							Blank
				textcolor 						Blank
				mousedown
				{
					appearance 					ShrinkButtonNormal
				}
				keyfocus
				{
					appearance					ShrinkButtonNormal
				}
				mouseover
				{
					appearance 					ShrinkButtonHover
				}
				disabled
				{
					appearance 					ShrinkButtonNormal
				}
				keyfocus_mouseover
				{
					appearance 					ShrinkButtonHover
				} 
				defaultbutton
				{
					appearance 					ShrinkButtonNormal
				}
				defaultbutton_mouseover
				{
					appearance 					ShrinkButtonHover
				}
			}
			
			icon_button_MiniMeExpand
			{
				appearance						ExpandButtonNormal
				bgcolor							Blank
				textcolor 						Blank
				mousedown
				{
					appearance 					ExpandButtonNormal
				}
				keyfocus
				{
					appearance					ExpandButtonNormal
				}
				mouseover
				{
					appearance 					ExpandButtonHover
				}
				disabled
				{
					appearance 					ExpandButtonNormal
				}
				keyfocus_mouseover
				{
					appearance 					ExpandButtonHover
				} 
				defaultbutton
				{
					appearance 					ExpandButtonNormal
				}
				defaultbutton_mouseover
				{
					appearance 					ExpandButtonHover
				}
			}
			
			icon_button_home
			{
				appearance						HomeButtonNormal
				bgcolor							Blank
				textcolor						Blank
				mousedown
				{
					appearance					HomeButtonDepressed
					textcolor					Blank
				}
				keyfocus
				{
					appearance					HomeButtonNormal
					textcolor					Blank
				}
				mouseover
				{
					appearance					HomeButtonHover
					textcolor					Blank
				}
				disabled
				{
					appearance					HomeButtonNormal
					textcolor					Blank
				}
				keyfocus_mouseover
				{
					appearance					HomeButtonHover
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance					HomeButtonNormal
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					HomeButtonHover
					textcolor					Blank
				}
			}
			
			icon_button_reload
			{
				appearance						ReloadButtonNormal
				bgcolor							Blank
				textcolor						Blank
				mousedown
				{
					appearance 					ReloadButtonDepressed
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					ReloadButtonNormal
					textcolor					Blank
				}
				mouseover
				{
					appearance 					ReloadButtonHover
					textcolor					Blank
				}
				disabled
				{
					appearance					ReloadButtonNormal
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance					ReloadButtonHover
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					ReloadButtonNormal
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					ReloadButtonHover
					textcolor					Blank
				}
			}
			
			icon_button_back
			{
				appearance						BackButtonNormal
				bgcolor							Blank
				textcolor						Blank
				mousedown
				{
					appearance 					BackButtonDepressed
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					BackButtonNormal
					textcolor					Blank
				}
				mouseover
				{
					appearance 					BackButtonHover
					textcolor					Blank
				}
				disabled
				{
					appearance 					BackButtonDisabled
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					BackButtonHover
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					BackButtonNormal
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					BackButtonHover
					textcolor					Blank
				}
			}
			
			icon_button_forward
			{
				appearance						ForwardButtonNormal
				bgcolor							Blank
				textcolor						Blank
				mousedown
				{
					appearance 					ForwardButtonDepressed
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					ForwardButtonNormal
					textcolor					Blank
				}
				mouseover
				{
					appearance 					ForwardButtonHover
					textcolor					Blank
				}
				disabled
				{
					appearance					ForwardButtonDisabled
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					ForwardButtonHover
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					ForwardButtonNormal
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					ForwardButtonHover
					textcolor					Blank
				}
			}
			
			icon_button_stop
			{
				appearance						StopButtonNormal
				bgcolor							Blank
				textcolor						Blank
				mousedown
				{
					appearance					StopButtonDepressed
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					StopButtonNormal
					textcolor					Blank
				}
				mouseover
				{
					appearance 					StopButtonHover
					textcolor					Blank
				}
				disabled
				{
					appearance					StopButtonNormal
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					StopButtonHover
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					StopButtonNormal
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					StopButtonHover
					textcolor					Blank
				}
			}
			
			Label
			{
				textcolor						TextBright
				bgcolor							Blank
				selectedtextcolor				TextBright
			}
			
			LabelDull
			{
				textcolor						TextNormal
				bgcolor							Blank
				selectedtextcolor				TextBright
			}
			
			LabelBright
			{
				textcolor						RedDark
				bgcolor							Blank
				selectedtextcolor				RedBright
			}
			
			ListPanel
			{
				appearance						ListPanelExteriorBorder
				bgcolor							Blank
			}
			
			ListPanelCheckBox
			{
				textcolor						TextNormal
				selected	
				{
					textcolor 					TextBright
				}
				selected_mouseover	
				{ 
					textcolor 					TextBright
				}
				selected_mousedown
				{
					textcolor 					TextDim
				}
				selected_keyfocus
				{
					textcolor 					TextBright
				}
				selected_keyfocus_mouseover
				{
					textcolor 					TextBright 
				}
			}
			
			ListPanelInterior
			{
				appearance						ListPanelInteriorBorder
				bgcolor							Blank
				scrollbar_visible
				{
					appearance					ListPanelInteriorBorder
				}
			}
			
			ListPanelSectionHeader
			{
				appearance						NoBorder
				bgcolor							SectionHeaderBG
				textcolor						SectionHeaderText
			}
			
			ListPanelSectionCollapser
			{
				bgcolor							Blank
				textcolor						SectionHeaderBG
			}
			
			ListPanelColumnHeader	
			{
				appearance						ListPanel.HeaderButtonBorder
				bgcolor							Blank
				textcolor  						TextNormal
				mouseover
				{
					appearance					ListPanel.HeaderButtonBorderHover
					textcolor 					TextBright
				}
			}
			
			ListPanelDragger
			{
				appearance						ListPanelDraggerBorder
			}

			ListViewPanel
			{
				appearance						InsetBorder
			}
			
			Menu
			{
				appearance						MenuBorder
				bgcolor							BaseDark
			}

			MenuBar		
			{
				appearance						NoBorder
				bgcolor							Blank
			}
			
			MenuBarItem
			{
				textcolor						TextNormal
				bgcolor							Blank
				mouseover
				{
					textcolor					TextBright
				}
				mousedown
				{
					textcolor					TextBright
				}
				selected
				{
					textcolor					TextBright
				}
			}
			
			MenuItem
			{
				textcolor						TextNormal
				bgcolor							BaseDark
				mouseover
				{
					textcolor 					TextBright
					bgcolor 					SelectedBGColor
				}
				disabled
				{
					textcolor					TextDisabled
				}
			}
			
			MenuSeparator
			{
				textcolor						Blank
				bgcolor							Blank
				appearance		
				{ 
					render_bg 
					{ 
						"1"						"fill( x0, y0, x1, y1, BaseDark )" 
						"2"						"fill( x0 + 2, y0 + 1, x1 - 2, y0 + 2, SepLight )"
					} 
				}
			}
			
			NotificationFrame
			{
				appearance						ToolTipBorder
				bgcolor							Blank
				textcolor						TextBright
			}
			
			PanelListPanel
			{
				appearance						InsetBorder
			}
			
			PanelHorizListPanel
			{
				appearance						InsetBorder
			}
			
			PageTab
			{
				appearance						TabBorder
				bgcolor							Blank
				textcolor						TextDark
				mouseover
				{
					appearance					TabBorderHover
					textcolor					TextNormal
				}
				mousedown
				{
					textcolor					TextNormal
				}
				active	
				{ 
					appearance					TabActiveBorder
					textcolor					TextNormal
				}
				keyfocus		
				{
					appearance 					TabActiveBorder
					textcolor					TextNormal
				}
				keyfocus_mouseover
				{
					appearance 					TabActiveBorder
					textcolor 					TextNormal
				}
			}
			
			PropertyPage
			{
				appearance						PropertyPageBorder
			}
			
			SteamGamesPage
			{
				bgcolor							BaseDark
			}
				
			PropertySheet
			{
				bgcolor							Blank
				appearance						PropertySheetBorder
				bgcolor							Blank
				topleft
				{
					appearance					PropertySheetBorderTopLeft
				}
				topright
				{
					appearance					PropertySheetBorderTopRight
				}
			}
			
			ProgressBar
			{
				appearance						InputBorder
				bgcolor							Blank
				textcolor						ProgressColor
			}
			
			RadioButton
			{
				textcolor						TextNormal
				mouseover
				{
					textcolor 					TextNormal
				}
				mousedown	
				{
					textcolor 					TextDim
				}
				selected	
				{
					textcolor 					TextBright
				}
				keyfocus
				{
					textcolor 					TextNormal
				}
				keyfocus_mouseover
				{
					textcolor 					TextNormal
				}
				selected_mouseover	
				{ 
					textcolor 					TextBright
				}
				selected_mousedown
				{
					textcolor 					TextDim
				}
				selected_keyfocus
				{
					textcolor 					TextBright
				}
				selected_keyfocus_mouseover
				{
					textcolor 					TextBright 
				}
				disabled
				{
					textcolor					TextDisabled
				}
				selected_disabled
				{
					textcolor					TextDisabled
				}
			}
			
			RichText
			{
				appearance						ListPanelBorder
			}
			
			RichTextInterior
			{
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			ScrollBarSlider
			{
				slider		
				{
					appearance 					ScrollBarSliderBorder_Vertical
					bgcolor 					Blank
				}
				slider_horiz
				{
					appearance 					ScrollBarSliderBorder_Horizontal
					bgcolor 					Blank
				}
			}
			
			ScrollBarButton
			{
				appearance						ScrollBarButtonBorder
				textcolor						TextNormal
				mouseover	
				{
					appearance					ScrollBarButtonBorderHover
					textcolor 					TextBright
				}
			}
			
			SectionedListPanel
			{
				bgcolor							Blank
				appearance						ListPanelBorderSimple
			}

			SectionedListPanelInterior
			{
				bgcolor							Blank
				appearance						ListPanelInteriorBorderSimple
				scrollbar_visible
				{
					appearance					ListPanelInteriorBorderSimple
				}
			}
			
			SectionedListPanelItem
			{
				textcolor						TextNormal
				selected
				{
					textcolor					TextBright
					appearance
					{
						inset					 "0 0 0 0"
						render_bg
						{
							"0" 				"fill( x0 - 3, y0, x1, y1, SelectedBGColor )" 
						}
					}
				}
			}
			
			SectionedListPanelHeader
			{
				appearance						NoBorder
				bgcolor							SectionHeaderBG
				textcolor						SectionHeaderText
			}
			
			SectionedListPanelCollapser
			{
				bgcolor							Blank
				textcolor						SectionHeaderBG
			}
			
			Slider
			{
				bgcolor							Blank
				textcolor						SliderTickColor
				selectedtextcolor				BaseNormal
				disabled
				{
					textcolor					TextDim
				}
			}
			
			SplitterHandle
			{
				appearance						InsetBorder
			}
			
			TextEntry
			{
				appearance						InputBorder
				bgcolor							Blank
				textcolor						TextNormal
				selectedtextcolor				TextBright
				selectedbgcolor					TextDisabled
				disabled
				{
					appearance					InputBorderDisabled
					bgcolor						Blank
					textcolor					TextDim
					selectedtextcolor			TextNormal
					selectedbgcolor				SelectedBGColor
				}
			}
			
			ToggleButton
			{
				appearance						ButtonBorderNormal
				bgcolor							Blank
				textcolor						TextNormal
				mouseover
				{
					appearance					ButtonBorderHover
					textcolor 					TextNormal
				}
				mousedown	
				{
					appearance 					ButtonBorderDepressed
					textcolor					TextDim
				}
				disabled
				{
					appearance					ButtonBorderDisabled
					textcolor					TextDisabled
					shadowtextcolor				TextShadow
				}
				keyfocus
				{ 
					appearance					ButtonBorderNormal
					textcolor 					TextNormal
				}
				keyfocus_mouseover		
				{ 
					appearance 					ButtonBorderHover
					textcolor 					TextNormal
				}
				selected
				{
					appearance					ButtonBorderDepressed
					textcolor					TextDim
				}
				selected_mouseover
				{
					appearance					ButtonBorderDepressed
					textcolor					TextNormal
				}
				selected_mousedown
				{
					appearance					ButtonBorderDepressed
					textcolor					TextDim
				}
				selected_keyfocus
				{
					appearance					ButtonBorderDepressed
					textcolor					TextDim
				}
				selected_keyfocus_mouseover
				{
					appearance					ButtonBorderDepressed
					textcolor					TextDim
				}
			}
			
			TooltipWindow
			{
				textcolor						TextBright
				appearance						ToolTipBorder
			}
			
			TreeView
			{
				textcolor						Blank
				bgcolor							Blank
			}
			
			TreeNode
			{
				textcolor						TextBright
				bgcolor							Blank
			}
			
			TreeViewSubPanel
			{
				appearance						ListPanelInteriorBorder
			}
			
			TreeNodeText
			{
				textcolor						TextBright
				bgcolor							Blank
				selectedtextcolor				TextBright
				selectedbgcolor					SelectedBGColor
			}
			
			URLLabel
			{
				textcolor						TextURL
				bgcolor							Blank
			}

			WizardPanel
			{
				bgcolor							Blank
				appearance						FrameBorder
			}
			
			WizardSubPanel
			{
				appearance						WizardBorder
				bgcolor							Blank
			}
		}
		
		FriendsControls
		{
			SectionedListPanelCollapser
			{
				bgcolor							Blank
				textcolor						SectionHeaderBG
				expanded
				{
					image						Icons/ListCollapse
				}
				collapsed
				{
					image						Icons/ListExpand
				}
				expanded_focus
				{
					image						Icons/ListCollapseOver
				}
				collapsed_focus
				{
					image						Icons/ListExpandOver
				}
			}
		}	
		
		SendGiftControls
		{
			ListPanel.TextColor					TextBright
			ListPanel.BgColor					Blank
			ListPanel.SelectedTextColor			TextBright
			ListPanel.SelectedBgColor			SelectedBGColor
			ListPanel.SelectedOutOfFocusBgColor	SelectedBGColor
			ListPanel.DisabledTextColor			TextDisabled
			ListPanel.DisabledSelectedTextColor	TextDisabled
			ListPanel.EmptyListInfoTextColor	TextDim
			ListPanel.RowHeight					20
			ListPanel.PerPixelScrolling			1
			
			ListPanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}
			
			ListPanelInterior
			{
				appearance						ListPanelInteriorBorder
				bgcolor							Blank
				scrollbar_visible
				{
					appearance					ListPanelInteriorBorder
				}
			}
			
			ListPanelColumnHeader	
			{
				appearance						NoBorder
				bgcolor							Blank
				textcolor  						Blank
				mouseover
				{
					appearance					NoBorder
					textcolor 					Blank
				}
			}
		}
		
		GamesPageControls
		{
			SectionedListPanelCollapser
			{
				bgcolor							Blank
				textcolor						SectionHeaderBG
				expanded
				{
					image						Icons/ListCollapse
				}
				collapsed
				{
					image						Icons/ListExpand
				}
				expanded_focus
				{
					image						Icons/ListCollapseOver
				}
				collapsed_focus
				{
					image						Icons/ListExpandOver
				}
			}
			
			ListPanelSectionCollapser
			{
				bgcolor							Blank
				textcolor						SectionHeaderBG
				expanded
				{
					image						Icons/ListCollapse
				}
				collapsed
				{
					image						Icons/ListExpand
				}
				expanded_focus
				{
					image						Icons/ListCollapseOver
				}
				collapsed_focus
				{
					image						Icons/ListExpandOver
				}
			}
		}
		
		WizardSubPanelControls
		{
			SectionedListPanelInterior
			{
				bgcolor							BaseDark
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			HTML
			{
				bgcolor							Blank
			}
			
			HTMLInterior
			{
				bgcolor							Blank
				appearance						HTMLInteriorBorder
				scrollbar_visible
				{
					appearance					HTMLInteriorBorder
				}
			}
		}
		
		PropertyPageControls
		{			
			SectionedListPanelInterior
			{
				bgcolor							BaseDark
				appearance						ListPanelInteriorBorderSimple
				scrollbar_visible
				{
					appearance					ListPanelInteriorBorderSimple
				}
			}
			
			HTML
			{
				bgcolor							Blank
			}
			
			HTMLInterior
			{
				bgcolor							Blank
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
		}
	}

	//////////////////////// Layout /////////////////////////////
	LayoutTemplates
	{
		Frame
		{
			frame_menu
			{
				visible							0	// hidden
			}
			
			frame_title
			{
				xpos							6
				ypos							1
				wide							r35
				tall							20
				AutoResize						1
			}
			
			frame_captiongrip
			{
				xpos							4
				ypos							4
				wide							r20
				tall							20
				AutoResize						1
			}
			
			frame_minimize
			{
				xpos							r36
				ypos							2
				wide							16
				tall							16
				PinCorner						1
			}
			
			frame_close
			{
				xpos							r18
				ypos							2
				wide							16
				tall							16
				PinCorner						1
			}

			frame_brGrip
			{
				xpos							r23
				ypos							r23
				wide							20
				tall							20
				PinCorner						3
			}
		}
		
		PropertyDialog
		{
			sheet
			{
				xpos							8
				ypos							26
				wide							r8
				tall							r48
			}
			
			ApplyButton
			{
				xpos							r84
				ypos							r36
				wide							72
				tall							24
			}
			
			CancelButton
			{
				xpos							r164
				ypos							r36
				wide							72
				tall							24
			}
			
			OKButton
			{
				xpos							r244
				ypos							r36
				wide							72
				tall							24
			}
		}
		
		WizardPanel
		{
			subpanel
			{
				xpos							8
				ypos							28
				wide							r8
				tall							r48
				AutoResize						3
			}
		
			PrevButton
			{
				xpos							r280
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			NextButton
			{
				xpos							r188
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			CancelButton
			{
				xpos							r96
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			FinishButton
			{
				xpos							r96
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
		}
	}

	//////////////////////// FONTS /////////////////////////////
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		// fonts are used in order that they are listed
		"Default"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"0"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"16"
				"weight"						"1000"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"800"
				"underline" 					"1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"11"
				"weight"						"0"
			}
		}
		"ListSmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"800"
			}
		}
		"DefaultLarge"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"18"
				"weight"						"0"
			}
		}
		"UiBold"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"14"
				"weight"						"1000"
			}
		}
		"HeadlineLarge"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"22"
				"weight"						"1000"
				"antialias"						"1"
			}
		}
		"UiHeadline"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"0"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"							"Verdana"
				"tall"							"16"
				"weight"						"600"
				"antialias" 					"1"
			}
		}
		"Marlett"
		{
			"1"
			{
				"name"							"Marlett"
				"tall"							"14"
				"weight"						"0"
				"symbol"						"1"
			}
		}
		MarlettLarge
		{
			"1"
			{
				"name"							"Marlett"
				"tall"							"16"
				"weight"						"0"
				"symbol"						"1"
			}
		}
		"DefaultFixed"
		{
			"1"
			{
				"name"							"Lucida Console"
				"tall"							"10"
				"weight"						"0"
			}
		}
		FriendsSmall
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"800"
			}
		}
		FriendsMedium
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"14"
				"weight"						"800"
			}
		}
		FriendsVerySmall
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
			}
		}
		FriendsVerySmallUnderline
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
				"underline"						"1"
			}
		}
		OverlayTaskbarFont
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"16"
				"weight"						"1000"
			}
		}
	}

	//////////////////// APPEARANCES //////////////////////////////
	Appearances
	{
		// render render_bg
		// image fill gradient corner dashedrect
		
		BaseBorder				NoBorder
		ComboBoxBorder			NoBorder
		BrowserBorder			NoBorder
		CheckBorder				NoBorder
		
		PropertySheetBorder
		{
			render_bg
			{
				"1"				"fill( x0, y1, x1, y1 + 1, SepDark )"
				"2"				"fill( x0, y1 + 1, x1, y1 + 2, SepLight )"
			}
		}

		PropertyPageBorder
		{
			render_bg
			{
				"1"				"fill( x0, y0 + 1, x1, y1, BaseDark )"
				"2"				"fill( x0, y0 + 1, x1, y0 + 10, BasePanelTop )"
				"3"				"gradient( x0, y0 + 10, x1, y0 + 100, BasePanelTop, BaseDark )"
			}
		}
		
		WizardBorder
		{
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, TitleTop )"
				"10"			"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, BaseDark )"
				"11"			"gradient( x0 + 1, y0 + 1, x1 - 1, y0 + 100, BasePanelTop, BaseDark )"
			}
		}
		
		ListPanel.HeaderButtonBorder
		{
			render_bg
			{
				"1"				"image( x0, y0, x1, y0 + 22, Graphics/ListPanelHeader_Normal )"
			}
			render
			{
				"2"				"fill( x0, y0, x0 + 1, y1, SepDark )"
				"3"				"fill( x0 + 1, y0, x0 + 2, y1, SepLight )"
			}
		}
		
		ListPanel.HeaderButtonBorderHover
		{
			render_bg
			{
				"1"				"image( x0, y0, x1, y0 + 22, Graphics/ListPanelHeader_Hover )"
			}
			render
			{
				"2"				"fill( x0, y0, x0 + 1, y1, SepDark )"
				"3"				"fill( x0 + 1, y0, x0 + 2, y1, SepLight )"
			}
		}
		
		ListPanel.HeaderButtonBorderDepressed	ListPanel.HeaderButtonBorder
		ListPanel.HeaderButtonBorderKeyFocus	ListPanel.HeaderButtonBorder
		
		ListPanelDraggerBorder					NoBorder

		TitleButtonBorder						RaisedBorder
		TitleButtonBorderDepressed 				InsetBorder
		
		TitleButtonDisabledBorder
		{
			"backgroundtype" 	"0"
		}
		
		FrameButtonNormal
		{
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/FrameButtonNormal )"
			}
		}
		
		FrameButtonHover
		{
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/FrameButtonHover )"
			}
		}
		
		MenuBorder
		{
			"corner_rounding"	"3"
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, BaseLight )"
				"2"				"fill( x1 - 1, y0, x1, y1, BaseLight )"
				"3"				"fill( x0, y1 - 1, x1, y1, BaseLight )"
				"4"				"fill( x0, y0, x0 + 1, y1, BaseLight )"
			}
		}
		
		FrameBorder
		{
			"corner_rounding"	"3"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, BaseNormal )"
				"2"				"gradient( x0, y0, x1, y0 + 20, TitleTop, TitleBottom )"
				"3"				"gradient( x0, y0 + 21, x1, y1 - 77, BaseNormal, BaseLight )"
				"4"				"gradient( x0, y1 - 77, x1, y1, BaseLight, BaseDark )"
			}
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, TitleTop )"
				"2"				"fill( x1 - 1, y0, x1, y1, TitleTop )"
				"3"				"fill( x0, y1 - 1, x1, y1, TitleTop )"
				"4"				"fill( x0, y0, x0 + 1, y1, TitleTop )"
			}
		}
		
		InsetBorder
		{
			"inset" 			"0 0 1 1"
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, GenericBorderDark )"
				"2"				"fill( x1 - 1, y0, x1, y1, GenericBorderBright )"
				"3"				"fill( x0, y1 - 1, x1, y1, GenericBorderBright )"
				"4"				"fill( x0, y0, x0 + 1, y1, GenericBorderDark )"
			}
		}
		
		DepressedBorder
		{
			"inset" 			"0 0 1 1"
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, GenericBorderBright )"
				"2"				"fill( x1 - 1, y0, x1, y1, GenericBorderDark )"
				"3"				"fill( x0, y1 - 1, x1, y1, GenericBorderDark )"
				"4"				"fill( x0, y0, x0 + 1, y1, GenericBorderBright )"
			}
		}
		
		RaisedBorder
		{
			"inset"				"0 0 1 1"
			render
			{
				"1"				"fill( x1, y0 + 1, x1 - 1, y1, GenericBorderDark )"
				"2"				"fill( x0, y0, x0 + 1, y1 - 1, GenericBorderBright )"
				"3"				"fill( x0, y0, x1, y0 + 1, GenericBorderBright )"
				"4"				"fill( x0 + 1, y1 - 1, x1, y1, GenericBorderDark )"
			}
		}
		
		ResizeBorder
		{
			render
			{
				"1"				"image( x0, y0, x1, y1, Icons/Resizer )"
			}
		}
		
		ScrollBarButtonBorder
		{
			"inset" 			"2 0 0 0"
			render_bg
			{
				"1"				"image( x0 + 3, y0 + 3, x0 + 18, y0 + 17, Buttons/ScrollButtonNormal )"
			}
		}
		
		ScrollBarButtonBorderHover
		{
			"inset" 			"2 0 0 0"
			render_bg
			{
				"1"				"image( x0 + 3, y0 + 3, x0 + 18, y0 + 17, Buttons/ScrollButtonHover )"
			}
		}
		
		ScrollBarSliderBorder
		{
			render_bg
			{
				"1"				"fill( x0 + 5, y0 + 1, x0 + 16, y1 - 1, BaseBright )"
				"2"				"fill( x0 + 4, y0 + 2, x0 + 17, y1 - 2, BaseBright )"
			}
		}
		
		ScrollBarSliderBorder_Vertical
		{
			render_bg
			{
				"1"				"fill( x0 + 3, y0 + 1, x0 + 18, y1 - 2, BaseBright )"
				"2"				"image( x0 + 4, y0 + 2, x0 + 17, y1 - 3, Graphics/ScrollSlider_Vertical )"
			}
		}
		
		ScrollBarSliderBorder_Horizontal
		{
			render_bg
			{
				"1"				"fill( x0 + 3, y0 + 1, x0 + 18, y1 - 2, BaseBright )"
				"2"				"image( x0 + 4, y0 + 2, x0 + 17, y1 - 3, Graphics/ScrollSlider_Horizontal )"
			}
		}
		
		TabBorder
		{
			inset				"10 0 0 0"
		}
		
		TabBorderHover
		{
			inset				"10 0 0 0"
			render_bg
			{
				"1"				"image(  x0 + 15, y0 + 7, x1, y1, Graphics/Tabs/TabNormal )"
				"2"				"image(  x0 + 5, y0 - 3, x0 + 15, y0 + 7, Graphics/Tabs/TabNormal_TL )"
				"3"				"image(  x1, y0 - 3, x1 + 10, y0 + 7, Graphics/Tabs/TabNormal_TR )"
				"4"				"image(  x0 + 15, y0 - 3, x1, y0 + 7, Graphics/Tabs/TabNormal_Top )"
				"5"				"image(  x0 + 5, y0 + 7, x0 + 15, y1, Graphics/Tabs/TabNormal_Left )"
				"6"				"image(  x1, y0 + 7, x1 + 10, y1, Graphics/Tabs/TabNormal_Right )"
			}
		}
		
		TabActiveBorder
		{
			inset				"10 0 0 0"
			render_bg
			{
				"1"				"image(  x0 + 15, y0 + 7, x1, y1, Graphics/Tabs/TabActive )"
				"2"				"image(  x0 + 5, y0 - 3, x0 + 15, y0 + 7, Graphics/Tabs/TabActive_TL )"
				"3"				"image(  x1, y0 - 3, x1 + 10, y0 + 7, Graphics/Tabs/TabActive_TR )"
				"4"				"image(  x0 + 15, y0 - 3, x1, y0 + 7, Graphics/Tabs/TabActive_Top )"
				"5"				"image(  x0 + 5, y0 + 7, x0 + 15, y1, Graphics/Tabs/TabActive_Left )"
				"6"				"image(  x1, y0 + 7, x1 + 10, y1, Graphics/Tabs/TabActive_Right )"
			}
		}
		
		ToolTipBorder
		{
			"corner_rounding" 	"2"
			render_bg
			{
				"1"				"gradient( x0, y0, x1, y1, BaseNormal, BaseDark )"
			}
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, GenericBorderBright )"
				"2"				"fill( x1 - 1, y0, x1, y1, GenericBorderBright )"
				"3"				"fill( x0, y1 - 1, x1, y1, GenericBorderBright )"
				"4"				"fill( x0, y0, x0 + 1, y1, GenericBorderBright )"
			}
		}
		
		NewsButtonNormal
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//NewsNormal )"
			}
		}
		NewsButtonHover
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//NewsHover )"
			}
		}
		FriendsButtonNormal
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//FriendsNormal )" }
		}
		FriendsButtonHover
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//FriendsHover )"
			}
		}
		ServersButtonNormal
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//ServersNormal )"
			}
		}
		ServersButtonHover
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//ServersHover )"
			}
		}
		SettingsButtonNormal
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//SettingsNormal )"
			}
		}
		SettingsButtonHover
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//SettingsHover )"
			}
		}
		SupportButtonNormal
		{
			inset				"-10 0 0 -10"
			render_bg
			{ 
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//SupportNormal )"
			}
		}
		SupportButtonHover
		{
			inset				"-10 0 0 -10"
			render_bg
			{
				"1"				"image( x0 + 5, y0, x1 - 5, y1, Buttons/Fancy//SupportHover )"
			}
		}
		
		ShrinkButtonNormal
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/ShrinkNormal )"
			}
		}
		ShrinkButtonHover
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/ShrinkHover )"
			}
		}
		ExpandButtonNormal
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/ExpandNormal )"
			}
		}
		ExpandButtonHover
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Buttons/ExpandHover )"
			}
		}
		HomeButtonNormal
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/HomeNormal )"
			}
		}
		HomeButtonHover
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/HomeHover )"
			}
		}
		HomeButtonDepressed
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/HomeDepressed )"
			}
		}
		ReloadButtonNormal
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ReloadNormal )"
			}
		}
		ReloadButtonHover
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ReloadHover )"
			}
		}
		ReloadButtonDepressed
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ReloadDepressed )"
			}
		}
		BackButtonNormal
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/BackNormal )"
			}
		}
		BackButtonHover
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/BackHover )"
			}
		}
		BackButtonDepressed
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/BackDepressed )"
			}
		}
		BackButtonDisabled
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/BackDisabled )"
			}
		}
		ForwardButtonNormal
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ForwardNormal )"
			}
		}
		ForwardButtonHover
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ForwardHover )"
			}
		}
		ForwardButtonDepressed
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ForwardDepressed )"
			}
		}
		ForwardButtonDisabled
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/ForwardDisabled )"
			}
		}
		StopButtonNormal
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/StopNormal )"
			}
		}
		StopButtonHover
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/StopHover )"
			}
		}
		StopButtonDepressed
		{
			inset				"0 0 8 0"
			render_bg
			{
				"1"				"image( x0, y0, x1, y1, Icons/Navigation/StopDepressed )"
			}
		}
		
		ButtonBorderNormal
		{
			inset				"4 3 4 4"
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, ButtonBorderNormal )"
				"10"			"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonNormal )"
			}
		}
		
		ButtonBorderHover
		{
			inset				"4 3 4 4"
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, ButtonBorderHover )"
				"10"			"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonHover )"
			}
		}
		
		ButtonBorderKeyFocus
		{
			inset				"4 3 4 4"
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, ButtonBorderNormal )"
				"10"			"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonNormal )"		
			}
		}
		
		ButtonBorderDefault
		{
			inset				"4 3 4 4"
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, ButtonBorderDefault )"
				"10"			"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonNormal )"		
			}
		}
		
		ButtonBorderDefaultHover
		{
			inset				"4 3 4 4"
			render_bg
			{
				"1"				"image( x0 - 5, y0 - 5, x0 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTL )"
				"2"				"image( x0 + 5, y0 - 5, x1 - 5, y0, Graphics/Shadows/ShadowOuterT )"
				"3"				"image( x1 - 5, y0 - 5, x1 + 5, y0 + 5, Graphics/Shadows/ShadowOuterTR )"
				"4"				"image( x0 - 5, y0 + 5, x0, y1 - 5, Graphics/Shadows/ShadowOuterL )"
				"5"				"image( x1, y0 + 5, x1 + 5, y1 - 5, Graphics/Shadows/ShadowOuterR )"
				"6"				"image( x0 - 5, y1 - 5, x0 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBL )"
				"7"				"image( x0 + 5, y1, x1 - 5, y1 + 5, Graphics/Shadows/ShadowOuterB )"
				"8"				"image( x1 - 5, y1 - 5, x1 + 5, y1 + 5, Graphics/Shadows/ShadowOuterBR )"
				"9"				"fill( x0, y0, x1, y1, ButtonBorderDefaultHover )"
				"10"			"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonHover )"
			}
		}
		
		ButtonBorderDepressed
		{
			inset				"6 5 4 4"
			render_bg
			{
				"1"				"fill( x0, y0, x1 - 1, y0 + 1, GenericBorderDark )"
				"2"				"fill( x0, y0, x0 + 1, y1 - 1, GenericBorderDark )"
				"3"				"fill( x0 + 1, y1 - 1, x1, y1, GenericBorderBright )"
				"4"				"fill( x1 - 1, y0 + 1, x1, y1, GenericBorderBright )"
				"5"				"image( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Buttons/ButtonDepressed )"		
			}
			render
			{
				"6"				"image( x0 + 1, y0 + 1, x0 + 6, y0 + 6, Graphics/Shadows/ShadowInnerTL )"
				"7"				"image( x0 + 6, y0 + 1, x1 - 1, y0 + 6, Graphics/Shadows/ShadowInnerT )"
				"8"				"image( x0 + 1, y0 + 6, x0 + 6, y1 - 1, Graphics/Shadows/ShadowInnerL )"
			}
		}
		
		ButtonBorderDisabled
		{
			inset				"4 4 4 4"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, ButtonBorderDisabled )"
			}
		}
		
		ListPanelBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"fill( x0 - 1, y0 - 1, x1 + 1, y1 + 1, GenericBorderBright )"
				"2"				"image_tiled( x0, y0, x1, y1, Graphics/Stripes )"
			}
			render
			{
				"3"				"image( x0, y0, x0 + 10, y0 + 10, Graphics/Shadows/ShadowInnerTL )"
				"4"				"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/Shadows/ShadowInnerT )"
				"5"				"image( x1 - 10, y0, x1, y0 + 10, Graphics/Shadows/ShadowInnerTR )"
				"6"				"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/Shadows/ShadowInnerL )"
				"7"				"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/Shadows/ShadowInnerR )"
				"8"				"image( x0, y1 - 10, x0 + 10, y1, Graphics/Shadows/ShadowInnerBL )"
				"9"				"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/Shadows/ShadowInnerB )"
				"10"			"image( x1 - 10, y1 - 10, x1, y1, Graphics/Shadows/ShadowInnerBR )"
			}
		}
		
		ListPanelInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image_tiled( x0, y0, x1, y1, Graphics/Stripes )"
			}
			render
			{
				"2"				"image( x0, y0, x0 + 10, y0 + 10, Graphics/Shadows/ShadowInnerTL )"
				"3"				"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/Shadows/ShadowInnerT )"
				"4"				"image( x1 - 10, y0, x1, y0 + 10, Graphics/Shadows/ShadowInnerTR )"
				"5"				"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/Shadows/ShadowInnerL )"
				"6"				"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/Shadows/ShadowInnerR )"
				"7"				"image( x0, y1 - 10, x0 + 10, y1, Graphics/Shadows/ShadowInnerBL )"
				"8"				"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/Shadows/ShadowInnerB )"
				"9"				"image( x1 - 10, y1 - 10, x1, y1, Graphics/Shadows/ShadowInnerBR )"
			}
		}
		
		ListPanelBorderSimple
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image_tiled( x0, y0, x1, y1, Graphics/Stripes )"
			}
			render
			{
				"2"				"image( x0, y0, x0 + 10, y0 + 10, Graphics/Shadows/ShadowInnerTL )"
				"3"				"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/Shadows/ShadowInnerT )"
				"4"				"image( x1 - 10, y0, x1, y0 + 10, Graphics/Shadows/ShadowInnerTR )"
				"5"				"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/Shadows/ShadowInnerL )"
				"6"				"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/Shadows/ShadowInnerR )"
				"7"				"image( x0, y1 - 10, x0 + 10, y1, Graphics/Shadows/ShadowInnerBL )"
				"8"				"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/Shadows/ShadowInnerB )"
				"9"				"image( x1 - 10, y1 - 10, x1, y1, Graphics/Shadows/ShadowInnerBR )"
			}
		}
		
		ListPanelInteriorBorderSimple
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image_tiled( x0, y0, x1, y1, Graphics/Stripes )"
			}
			render
			{
				"2"				"image( x0, y0, x0 + 10, y0 + 10, Graphics/ShadowInnerTL )"
				"3"				"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/ShadowInnerT )"
				"4"				"image( x1 - 10, y0, x1, y0 + 10, Graphics/ShadowInnerTR )"
				"5"				"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/ShadowInnerL )"
				"6"				"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/ShadowInnerR )"
				"7"				"image( x0, y1 - 10, x0 + 10, y1, Graphics/ShadowInnerBL )"
				"8"				"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/ShadowInnerB )"
				"9"				"image( x1 - 10, y1 - 10, x1, y1, Graphics/ShadowInnerBR )"
			}
		}
		
		ListPanelExteriorBorder
		{
			render_bg
			{
				"1"				"image( x0, y0, x1, y0 + 22, Graphics/ListPanelHeader_Normal )"
			}
			render
			{
				"2"				"fill( xo, y0 + 21, x1, y0 + 22, BaseBright )"
			}
		}
		
		HTMLInteriorBorder
		{
			render
			{
				"1"				"image( x0, y0, x0 + 10, y0 + 10, Graphics/Shadows/ShadowInnerTL )"
				"2"				"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/Shadows/ShadowInnerT )"
				"3"				"image( x1 - 10, y0, x1, y0 + 10, Graphics/Shadows/ShadowInnerTR )"
				"4"				"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/Shadows/ShadowInnerL )"
				"5"				"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/Shadows/ShadowInnerR )"
				"6"				"image( x0, y1 - 10, x0 + 10, y1, Graphics/Shadows/ShadowInnerBL )"
				"7"				"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/Shadows/ShadowInnerB )"
				"8"				"image( x1 - 10, y1 - 10, x1, y1, Graphics/Shadows/ShadowInnerBR )"
			}
		}
		
		HTMLExteriorBorder
		{
			render
			{
				"1"				"fill( x0 - 1, y0 - 1, x1 + 1, y0, GenericBorderBright )"
				"2"				"fill( x0 - 1, y0 - 1, x0, y1 + 1, GenericBorderBright )"
				"3"				"fill( x1, y0 - 1, x1 + 1, y1 + 1, GenericBorderBright )"
				"4"				"fill( x0 - 1, y1, x1 + 1, y1 + 1, GenericBorderBright )"
			}
		}
		
		InputBorder
		{
			inset				"4 0 4 0"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderBright )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, InputBorderBackground )"
			}
			render
			{
				"3"				"image( x0, y0, x0 + 5, y0 + 5, Graphics/Shadows/ShadowInnerTL )"
				"4"				"image( x0 + 5, y0, x1, y0 + 5, Graphics/Shadows/ShadowInnerT )"
				"5"				"image( x0, y0 + 5, x0 + 5, y1, Graphics/Shadows/ShadowInnerL )"
			}
		}
		
		InputBorderDisabled
		{
			inset				"4 0 4 0"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderDisabled )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, InputBorderBackground )"
			}
			render
			{
				"3"				"image( x0, y0, x0 + 5, y0 + 5, Graphics/Shadows/ShadowInnerTL )"
				"4"				"image( x0 + 5, y0, x1, y0 + 5, Graphics/Shadows/ShadowInnerT )"
				"5"				"image( x0, y0 + 5, x0 + 5, y1, Graphics/Shadows/ShadowInnerL )"
			}
		}
		
		NoBorder
		{
			"inset" 			"0 0 0 0"
			render
			{
			}
		}
		
		ChatHistoryPanelDefault
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderBright )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, BaseDark )"
			}
		}
		
		ChatInputBorder
		{
			inset				"2 2 2 2"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderBright )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, InputBorderBackground )"
			}
			render
			{
				"3"				"image( x0, y0, x0 + 5, y0 + 5, Graphics/Shadows/ShadowInnerTL )"
				"4"				"image( x0 + 5, y0, x1, y0 + 5, Graphics/Shadows/ShadowInnerT )"
				"5"				"image( x0, y0 + 5, x0 + 5, y1, Graphics/Shadows/ShadowInnerL )"
			}
		}
		
		ChatInputBorderDisabled
		{
			inset				"2 2 2 2"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderDisabled )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, InputBorderBackground )"
			}
			render
			{
				"3"				"image( x0, y0, x0 + 5, y0 + 5, Graphics/Shadows/ShadowInnerTL )"
				"4"				"image( x0 + 5, y0, x1, y0 + 5, Graphics/Shadows/ShadowInnerT )"
				"5"				"image( x0, y0 + 5, x0 + 5, y1, Graphics/Shadows/ShadowInnerL )"
			}
		}
		
		ChatUserPanelDefault
		{
			inset				"0 0 0 0"
			render_bg
			{
				"1"				"image_tiled( x0, y0, x1, y1, Graphics/Stripes )"
			}
			render
			{
				"2"				"image( x0, y0 + 1, x0 + 10, y0 + 11, Graphics/Shadows/ShadowInnerTL )"
				"3"				"image( x0 + 10, y0 + 1, x1 - 10, y0 + 11, Graphics/Shadows/ShadowInnerT )"
				"4"				"image( x1 - 10, y0 + 1, x1, y0 + 11, Graphics/Shadows/ShadowInnerTR )"
				"5"				"image( x0, y0 + 11, x0 + 10, y1 - 11, Graphics/Shadows/ShadowInnerL )"
				"6"				"image( x1 - 10, y0 + 11, x1, y1 - 11, Graphics/Shadows/ShadowInnerR )"
				"7"				"image( x0, y1 - 11, x0 + 10, y1 - 1, Graphics/Shadows/ShadowInnerBL )"
				"8"				"image( x0 + 10, y1 - 11, x1 - 10, y1 - 1, Graphics/Shadows/ShadowInnerB )"
				"9"				"image( x1 - 10, y1 - 11, x1, y1 - 1, Graphics/Shadows/ShadowInnerBR )"
				"10"			"fill( x0 - 1, y0, x1 + 1, y0 + 1, GenericBorderBright )"
				"11"			"fill( x0 - 1, y0 + 1, x0, y1 - 1, GenericBorderBright )"
				"12"			"fill( x1, y0 + 1, x1 + 1, y1 - 1, GenericBorderBright )"
				"13"			"fill( x0 - 1, y1 - 1, x1 + 1, y1, GenericBorderBright )"
			}
		}
		
		VoiceChatOffBG
		{
			inset				"1 1 1 1"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderBright )"
				"2"				"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, BaseDark )"
			}
		}
		
		VoiceChatOnBG
		{
			inset				"1 1 1 1"
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, GenericBorderBright )"
				"2"				"gradient( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ChatGradientTop, ChatGradientBottom )"
			}
		}
		
		ChatInviteBG
		{
			inset				"1 1 1 1"
			render
			{
				"1"				"fill( x0 - 1, y0, x1 + 1, y1 + 1, GenericBorderBright )"
				"2"				"fill( x0, y0 + 1, x1, y1, BaseDark )"
			}
		}
		
		FriendPanelDefault
		{
			render_bg
			{
			    "1"				"fill(  x0 + 2, y0 + 2, x1, y1, Friends.PanelDefault )"
			}
		}
		
		FriendPanelMouseOver
		{
			render_bg
			{
				"1"				"fill( x0, y0 + 2, x1, y1, FriendPanelHoverOutline )"
				"2"				"gradient( x0 + 1, y0 + 3, x1 - 1, y1 - 1, BaseDark, BaseNormal )"
			}
		}
		
		FriendPanelSelected
		{
			render_bg
			{
				"1"				"fill( x0, y0 + 2, x1, y1, FriendPanelSelectedOutline )"
				"2"				"image( x0 + 1, y0 + 3, x1 - 1, y1 - 1, Graphics/Friends/Selected )"
			}
		}
		
		FriendPanelAffordance
		{
			render_bg
			{
				"1"				"image(  x0 + 2, y0 + 1, x1 - 1, y1 - 2, Graphics/Friends/Affordance_Normal )"
			}
		}
		
		FriendPanelAffordanceMouseOver
		{
			render_bg
			{
				"1"				"image(  x0 + 2, y0 + 1, x1 - 1, y1 - 2, Graphics/Friends/Affordance_Hover )"
			}
		}
	}
}